
(define (manual s)
  (format "<I>~a</I>" s))

(define docs
  `(("all" "All manuals")
    ("standard" "Standard manuals")
    ("drscheme" ,(manual "PLT DrScheme: Programming Environment Manual"))
    ("drschemejr" ,(manual "PLT DrScheme Jr: Programming Shell Manual"))
    ("insidemz" ,(manual "Inside PLT MzScheme"))
    ("match" ,(manual "Pattern Matching for Scheme"))
    ("mrspidey" ,(manual "PLT MrSpidey: Static Debugger Manual"))
    ("mzc" ,(manual "PLT mzc: MzScheme Compiler Manual"))
    ("mzscheme" ,(manual "PLT MzScheme: Language Reference Manual"))
    ("r4rs" ,(manual "R4RS"))
    ("toolbox" ,(manual "PLT MrEd: Graphical Toolbox Manual"))
    ("master" (manual "Master Index for PLT Documentation"))))

(define formats
  '(("dvi.tar.gz" "DVI, tarred and gzipped")
    ("html.tar.gz" "HTML, tarred and gzipped")
    ("html.zip" "HTML, zipped")
    ("ps.tar.gz" "PostScript, tarred and gzipped")
    ("ps.zip" "PostScript, zipped")))

(printf "<HTML>~n<HEAD>~n<TITLE>Old PLT Documentation:Version 53</TITLE>~n</HEAD>~n")

(printf "<BODY bgcolor=\"#ffffff\">~n<H1>~n")
(printf "<IMG SRC=\"../drscheme/logo.gif\" ALIGN=center ALT=\"[PLT logo]\">Old PLT Documentation: Version 53~n")
(printf "</H1>~n")

(printf "<TABLE>~n")
(printf "<TR><TD bgcolor=\"#ccccff\">Document</TD>")
(for-each
 (lambda (f)
   (printf "<TD bgcolor=\"#ccccff\">~a</TD>" (car f)))
 formats)
(printf "</TR>~n")

(for-each
 (lambda (doc)
   (printf "<TR><TD bgcolor=\"#ccccff\">~a</TD>" (cadr doc)) 
   (for-each
    (lambda (f)
      (printf 
       "<TD><A HREF=\"http://www.cs.rice.edu/CS/PLT/packages/download/53/doc/~a-~a\">~a</A></TD>" 
       (car doc) (car f) (car f)))
    formats)
   (printf "</TR>~n"))
 docs)
(printf "</TABLE>~n")

  
(printf "<P>~n")
(printf "Formats:~n<UL>~n")

(for-each
 (lambda (f)
   (printf "<LI> ~a = ~a" (car f) (cadr f)))
 formats)
(printf "</UL>~n")

(printf "<HR>~n<P>~n")
(printf "<table width=100%><TR><td align=right><address><A HREF=\"http://www.cs.rice.edu/CS/PLT/\">PLT</A>")
(printf " / scheme@cs.rice.edu</address></td></tr></table>~n</BODY>~n")

